/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkMilestone;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class VWWorkflowMilestonePanel
extends JPanel
implements ChangeListener,
MouseListener {
    private static final int COL_NAME = 0;
    private static final int COL_LEVEL = 1;
    private Frame m_parentFrame = null;
    private VWTrkDataModel m_trackerDataModel = null;
    private Vector m_milestones = null;
    private VWToolbarBorder m_messageBorder = null;
    private JTextArea m_messageArea = null;
    private VWTable m_milestoneTable = null;
    private JScrollPane m_tableScrollPane = null;
    private JScrollPane m_messageScrollPane = null;
    private VWMilestoneTableModel m_milestoneTableModel = null;

    public VWWorkflowMilestonePanel(Frame parentFrame, VWTrkDataModel dataModel) {
        this.m_parentFrame = parentFrame;
        this.m_trackerDataModel = dataModel;
        this.initializeVars();
        this.setupLayout();
    }

    public void initialize() {
        if (this.m_trackerDataModel.getInitState() == 6) {
            this.m_milestones = this.m_trackerDataModel.getMilestones();
            if (this.m_milestoneTableModel != null) {
                this.m_milestoneTableModel.setData(this.m_milestones);
                this.m_milestoneTableModel.fireTableDataChanged();
            }
        }
        this.addMouseListener(this);
    }

    private void initializeVars() {
        this.m_milestoneTableModel = this.m_milestones != null ? new VWMilestoneTableModel(this.m_milestones) : new VWMilestoneTableModel();
    }

    private void setupLayout() {
        this.m_milestoneTable = new VWTable(this.m_milestoneTableModel){

            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                if (e.getValueIsAdjusting()) {
                    return;
                }
                String message = null;
                if (this.getRowCount() > 0 && this.getColumnCount() > 0) {
                    Object obj;
                    int index = this.getSelectedRow();
                    if (VWWorkflowMilestonePanel.this.m_milestones != null && index >= 0 && index < VWWorkflowMilestonePanel.this.m_milestones.size() && (obj = VWWorkflowMilestonePanel.this.m_milestones.elementAt(index)) != null && obj instanceof VWTrkMilestone) {
                        message = ((VWTrkMilestone)obj).getMessage();
                        if (VWWorkflowMilestonePanel.this.m_messageArea != null) {
                            VWWorkflowMilestonePanel.this.m_messageArea.setText(message);
                            VWWorkflowMilestonePanel.this.m_messageArea.updateUI();
                        }
                    }
                }
            }
        };
        this.m_milestoneTable.setRowSelectionAllowed(true);
        this.m_milestoneTable.setColumnSelectionAllowed(false);
        this.m_milestoneTable.setSelectionMode(0);
        TableColumnModel columnModel = this.m_milestoneTable.getColumnModel();
        TableColumn columnName = columnModel.getColumn(0);
        columnName.setMinWidth(100);
        TableColumn columnLevel = columnModel.getColumn(1);
        columnLevel.setMinWidth(20);
        this.m_tableScrollPane = new JScrollPane(this.m_milestoneTable);
        columnLevel.setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
                ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
                component.applyComponentOrientation(compOrientation);
                if (component instanceof JLabel) {
                    ((JLabel)component).setHorizontalAlignment(0);
                }
                return component;
            }
        });
        this.m_messageBorder = new VWToolbarBorder(VWResource.s_message, 0);
        JPanel panel = this.m_messageBorder.getClientPanel();
        panel.setLayout(new BorderLayout());
        this.m_messageArea = new JTextArea(3, 10);
        this.m_messageArea.setEditable(false);
        this.m_messageArea.setLineWrap(true);
        this.m_messageArea.setWrapStyleWord(true);
        this.m_messageScrollPane = new JScrollPane(this.m_messageArea);
        panel.add(this.m_messageScrollPane);
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 23;
        c.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.m_tableScrollPane, c);
        c.gridy = -1;
        this.add((Component)this.m_messageBorder, c);
    }

    public void stateChanged(ChangeEvent e) {
        JTabbedPane tabbedPane;
        if (e.getSource() instanceof JTabbedPane && (tabbedPane = (JTabbedPane)e.getSource()).getSelectedComponent() == this) {
            tabbedPane.removeChangeListener(this);
            this.m_milestoneTable.fitColumnsInTable();
            if (this.m_milestoneTable.getRowCount() > 0) {
                this.m_milestoneTable.setRowSelectionInterval(0, 0);
            }
        }
    }

    private void logShowException(Exception ex, String title) {
        VWDebug.logException(ex);
        String msg = ex.getLocalizedMessage();
        if (msg == null || msg.length() == 0) {
            msg = ex.getClass().getName();
        }
        JOptionPane.showMessageDialog(this.m_parentFrame, msg, title, 0, null);
    }

    public void mouseClicked(MouseEvent evt) {
        if (evt.getSource() == this.m_milestoneTable) {
            Object obj;
            Point point = evt.getPoint();
            int row = this.m_milestoneTable.rowAtPoint(point);
            String message = null;
            if (row >= 0 && row < this.m_milestones.size() && (obj = this.m_milestones.elementAt(row)) != null && obj instanceof VWTrkMilestone) {
                message = ((VWTrkMilestone)obj).getMessage();
            }
            if (this.m_messageArea != null) {
                this.m_messageArea.setText(message);
            }
        }
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void removeReferences() {
        this.m_parentFrame = null;
        this.m_trackerDataModel = null;
        this.m_milestones = null;
        this.m_messageArea = null;
        this.removeMouseListener(this);
        if (this.m_milestoneTable != null) {
            this.m_milestoneTable.removeReferences();
            this.m_milestoneTable = null;
        }
        if (this.m_tableScrollPane != null) {
            this.m_tableScrollPane.removeAll();
            this.m_tableScrollPane = null;
        }
        if (this.m_messageScrollPane != null) {
            this.m_messageScrollPane.removeAll();
            this.m_messageScrollPane = null;
        }
        if (this.m_milestoneTableModel != null) {
            this.m_milestoneTableModel.removeReferences();
            this.m_milestoneTableModel = null;
        }
        if (this.m_messageBorder != null) {
            this.m_messageBorder.removeReferences();
            this.m_messageBorder = null;
        }
        this.removeAll();
    }

    private class VWMilestoneTableModel
    extends AbstractTableModel {
        Vector m_data = null;
        String[] m_columnNames = new String[]{VWResource.s_milestone, VWResource.s_level};

        VWMilestoneTableModel() {
            this.m_data = null;
        }

        VWMilestoneTableModel(Vector data) {
            this.m_data = data;
        }

        public void setData(Vector data) {
            this.m_data = data;
        }

        public int getRowCount() {
            if (this.m_data != null) {
                return this.m_data.size();
            }
            return 0;
        }

        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public String getColumnName(int col) {
            if (col < 0 || col >= this.m_columnNames.length) {
                return null;
            }
            return this.m_columnNames[col];
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Integer.class;
                }
            }
            return null;
        }

        public Object getValueAt(int row, int col) {
            if (row < 0 || row >= this.getRowCount()) {
                return null;
            }
            VWTrkMilestone milestone = null;
            Object obj = this.m_data.elementAt(row);
            if (obj != null && obj instanceof VWTrkMilestone) {
                milestone = (VWTrkMilestone)obj;
            }
            if (milestone == null) {
                return null;
            }
            switch (col) {
                case 0: {
                    return milestone.getName();
                }
                case 1: {
                    return new Integer(milestone.getLevel());
                }
            }
            return null;
        }

        void removeReferences() {
            this.m_data = null;
            if (this.m_columnNames != null) {
                for (int i = 0; i < this.m_columnNames.length; ++i) {
                    this.m_columnNames[i] = null;
                }
                this.m_columnNames = null;
            }
        }
    }
}

